/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.flowable;

import dev.compactmods.crafting.lib.reactivestreams.Publisher;
import dev.compactmods.crafting.lib.reactivestreams.Subscription;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.FlowableSubscriber;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Single;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.SingleObserver;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.Disposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.NoSuchElementException;

public final class FlowableLastSingle<T>
extends Single<T> {
    final Publisher<T> source;
    final T defaultItem;

    public FlowableLastSingle(Publisher<T> source, T defaultItem) {
        this.source = source;
        this.defaultItem = defaultItem;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        this.source.subscribe(new LastSubscriber<T>(observer, this.defaultItem));
    }

    static final class LastSubscriber<T>
    implements FlowableSubscriber<T>,
    Disposable {
        final SingleObserver<? super T> downstream;
        final T defaultItem;
        Subscription upstream;
        T item;

        LastSubscriber(SingleObserver<? super T> actual, T defaultItem) {
            this.downstream = actual;
            this.defaultItem = defaultItem;
        }

        @Override
        public void dispose() {
            this.upstream.cancel();
            this.upstream = SubscriptionHelper.CANCELLED;
        }

        @Override
        public boolean isDisposed() {
            return this.upstream == SubscriptionHelper.CANCELLED;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            this.item = t;
        }

        @Override
        public void onError(Throwable t) {
            this.upstream = SubscriptionHelper.CANCELLED;
            this.item = null;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            this.upstream = SubscriptionHelper.CANCELLED;
            T v = this.item;
            if (v != null) {
                this.item = null;
                this.downstream.onSuccess(v);
            } else {
                v = this.defaultItem;
                if (v != null) {
                    this.downstream.onSuccess(v);
                } else {
                    this.downstream.onError(new NoSuchElementException());
                }
            }
        }
    }
}

